#include <string.h>
#include "tools.h"

// 测试当前文件的编码，如果是 UTF8 编码，则中文两个字占 6 字节，如果是 GBK 则占 4 字节
static int is_utf8_code(void)
{
    if (strlen("中文") == 6)
        return 1;
    return 0;
}

/* 返回字符串s的显示宽度，中文占两个英文字符的宽度
   如:
      "abc" -->3
      "中文" --> 4
      "ABC中文" --> 7
*/
int get_display_width(const char * s)
{
    int display_width = 0;
    int is_utf8 = is_utf8_code();
    // 计算字符串 s 占用屏幕控制台终端的宽度。
    while (*s) {
        if (*s >= 0 && *s <= 127) {  // 英文编码
            display_width++;  // 英文占一个字符宽
            s++;
        } else if (is_utf8) {  // 中文 UTF8 编码
            display_width += 2;  // 中文占两个字符宽
            s += 3;  // UTF8 编码一个汉字占 3 字节内存
        } else { // 中文 GBK 编码
            display_width += 2;
            s += 2;  // GBK 编码一个汉字占 2 字节内存
        }
    }

    return display_width;
}

/* 将字符串s的左右两端添加空格，使其达到 width 的显示宽度，存入 target 中
   如:
      s = 'ABC中文', width = 10
      返回:' ABC中文  '
*/
void center_to_display_width(const char * s, int width, char * target)
{
    // 得到当前字符的显示宽度
    int s_width = get_display_width(s);
    // 计算需要补充的空格数
    int fill_blank_count = width - s_width;

    // 计算左侧需要填充的空格数
    int left_blank = fill_blank_count / 2;
    // 计算右侧需要填充的空格数
    int right_blanks = fill_blank_count - left_blank;
    // 使用指针指向 target 的内容
    char * ptar = target;
    int i;

    if (fill_blank_count < 0) {  // 宽度小于 字符串宽度
        strcpy(target, s);
        return;
    }
    // 将 target 的左侧填充 fill 空格
    for (i = 0; i < left_blank; i++, ptar++) {
        *ptar = ' ';  // 填充空格
    }
    // 将 s 追加到 target 后面
    while(*s) {
        *ptar = *s;
        s++;
        ptar++;
    }
    // 将 target 的右侧填充空格
    for (i = 0; i < right_blanks; i++, ptar++) {
        *ptar = ' ';  // 填充空格
    }
    *ptar = '\0';   // 尾零
}
