#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "tools.h"
#include "school.h"
#include "class_room.h"

// 用于存放班级对象，初始状态为空
static class_room_t class_rooms[MAX_CLASS_COUNT_IN_SCHOOL] = {};
static int class_room_count = 0;  // 班级的个数

// 添加班级
void add_class_room(void)
{
    char class_title[MAX_CLASS_TITLE_LEN*2];

    // 判断是否达到班级的最大数量
    if (class_room_count >= MAX_CLASS_COUNT_IN_SCHOOL) {
        printf("已经达到了编辑的最大数量!\n");
        return;
    }

    printf("请输入班级名称: ");
    fflush(stdout);
    scanf("%s", class_title);
    if (get_display_width(class_title) <= 10) {
        strcpy(class_rooms[class_room_count].class_title, class_title);
        class_room_count++;
        printf("添加班级%s成功!\n", class_title);
    } else {
        printf("添加班级失败，班级名太长!\n");
    }

    sleep(2);
}

void list_all_class_room(void)
{
    int i;
    char class_title[MAX_CLASS_TITLE_LEN*2];

    printf("+------+------------+\n");
    printf("| 序号 |  班级名称  |\n");
    printf("+------+------------+\n");
    for (i = 0; i < class_room_count; i++) {
        center_to_display_width(class_rooms[i].class_title, 10, class_title);
        printf("| %4d | %s |\n", i+1, class_title);
    }
    if (class_room_count) 
        printf("+------+------------+\n");
}

// 删除班级
void del_class_room(void)
{
    int number = 0;
    int index;

    list_all_class_room();
    printf("请输入删除班级的序号: ");
    fflush(stdout);
    scanf("%d", &number);
    index = number - 1;  // 对应列表的索引
    if (index < 0 || index >= class_room_count) {
        printf("您输入的序号有误，删除失败!\n");
        sleep(2);
    }
    // 将后续编辑依次向前覆盖
    for (; index < class_room_count-1; index++) {
        class_rooms[index] = class_rooms[index+1];
    }
    class_room_count--;
    printf("删除成功!\n");
    sleep(2);
}

// 进入管理班级界面
void enter_class_manager(void)
{
    int number = 0;
    int index;
    class_room_t *aclass;

    list_all_class_room();
    printf("请输入一个要管理班级的序号: ");
    fflush(stdout);
    scanf("%d", &number);
    index = number - 1;  // 对应列表的索引
    if (index < 0 || index >= class_room_count) {
        printf("您输入的班级序号有误！\n");
        return;
    }
    aclass = &class_rooms[index];
    student_manager(aclass);
}

// 保存班级信息，成功返回 1，失败返回 0；
int save_to_csv_file(const char *path_name)
{
    const char * header = "班级名称,学生姓名,语文成绩,数学成绩";
    FILE * file = fopen(path_name, "w");  // 打开文件
    int i;

    if (NULL == file) {
        printf("打开文件失败，保存文件失败!\n");
        return 0;
    }
    fprintf(file, "%s\r\n", header);

    for (i = 0; i < class_room_count; i++) {
        writer_to_csv_writer(&class_rooms[i], file);
    }

    fclose(file);
    return 1;
}

// 加载班级信息，成功返回 1，失败返回 0；
int load_from_csv_file(const char *path_name)
{
    FILE * file = fopen(path_name, "r");  // 打开文件
    // 记录之前的班级名，重复班级名的学生是同一班的学生
    char last_class_title[MAX_CLASS_TITLE_LEN] = "";
    char line_buf[100] = ""; // 读取一行数据的缓冲区。
    char *pclass_title;  // 指向班级名
    char *pstudent_name;  //  指向学生名
    char *pchinese_score;  // 指向语文成绩的字符串
    char *pmath_score;  // 指向语文成绩的字符串
    char *p;  // 用于指向每一行行数据的临时指针

    if (NULL == file) {
        printf("打开文件失败，读取文件失败!\n");
        return 0;
    }

    class_room_count = 0;  //  清空原有数据

    // 读取一行，跳过头部的第一行标题
    fgets(line_buf, sizeof(line_buf), file);
    // 每次读取一行，然后解析每一行的数据
    while(NULL != fgets(line_buf, sizeof(line_buf), file)) {
        // 解析每一行的数据
        pclass_title = line_buf;
        // 找到逗号，逗号改成班级名的尾零.
        p = strstr(line_buf, ",");
        if (NULL == p)
            goto finished;
        *p = '\0';
        p++;  // 指向学生姓名
        // 指向学生姓名的起始地址。
        pstudent_name = p;
        p = strstr(p, ",");
        if (NULL == p)
            goto finished;
        *p = '\0';
        p++; // 指向语文成绩;

        // 指向学生语文成绩的起始地址。
        pchinese_score = p;
        p = strstr(p, ",");
        if (NULL == p)
            goto finished;
        *p = '\0';
        p++; // 指向语文成绩;

        // 指向学生数学成绩的起始地址。
        pmath_score = p;
        
        // 判断 班级名称发生改变。则说明已经是不同的班级
        if (0 != strcmp(last_class_title, pclass_title)) {
            // 如果已经超出了班级个数，则直接返回
            if (class_room_count == MAX_CLASS_COUNT_IN_SCHOOL) {
                goto finished;
            } else {
                // 初始化当前的班级信息
                strcpy(class_rooms[class_room_count].class_title, pclass_title);
                class_rooms[class_room_count].student_count = 0;
                class_room_count++;
            }
            strcpy(last_class_title, pclass_title);
        }
        // 
        // 将此学生信息添加到 class_room_count-1 这个班级中
        add_student_by_info(&class_rooms[class_room_count-1], 
            pstudent_name, atoi(pchinese_score), atoi(pmath_score));
        // 解析完毕，
    }
finished:
    fclose(file);
    return 1;
}

void show_school_menu(void) 
{
    printf("        xxxx小学信息管理系统\n");
    printf("+-----------------------------------+\n");
    printf("| 1) 添加班级                       |\n");
    printf("| 2) 删除班级                       |\n");
    printf("| 3) 进入管理班级                   |\n");
    printf("| 4) 列出所有班级                   |\n");
    printf("| 5) 保存班级信息                   |\n");
    printf("| 6) 加载班级信息                   |\n");
    printf("| 0) 退出程序                       |\n");
    printf("+-----------------------------------+\n");
    printf("请选择：");
    fflush(stdout);  // 清空缓冲区
}
// 此函数用来管理班级数据
void class_manager(void)
{
    while (1)
    {
        int sel = 0;
        show_school_menu();
        scanf("%d", &sel);
        switch (sel)
        {
            case 1:  // 1) 添加班级
                add_class_room();
                break;
            case 2:  // 2) 删除班级
                del_class_room();
                break;
            case 3:  // 3) 进入管理班级
                enter_class_manager();
                break;
            case 4:  // 4) 列出所有班级
                list_all_class_room();
                break;
            case 5:  // 5) 保存班级信息
                save_to_csv_file(DEFAULT_DOC_PATHNAME);
                break;
            case 6:  // 6) 加载班级信息
                load_from_csv_file(DEFAULT_DOC_PATHNAME);
                break;
            case 0:  // 0) 退出程序
                return;
            default:
                printf("不存在的选项，请重新输入\n");
                sleep(2);
        }
    }
}