#ifndef __CLASS_ROOM_H
#define __CLASS_ROOM_H

#include <stdio.h>
#include "student.h"

// 班级名称的最大长度
#define MAX_CLASS_TITLE_LEN (64)

// 定义每个班级最大学生个数。
#define MAX_STU_COUNT_IN_CLASS_ROOM  (100)  

// 班级的结构体
typedef struct class_room {
    char class_title[MAX_CLASS_TITLE_LEN];  // 班级名
    student_t student[MAX_STU_COUNT_IN_CLASS_ROOM]; // 每个班级的学生
    int student_count; // 用来记录具体的学生个数
} class_room_t;


// 添加学生信息
void add_student(class_room_t *aclass);
// 修改语文成绩功能
void modify_chinese_score(class_room_t *aclass);
// 修改数学成绩功能
void modify_math_score(class_room_t *aclass);
// 删除学生信息
void del_student(class_room_t *aclass);
// 显示所有学生的信息
void list_all_student_info(class_room_t *aclass);
// 写入一个班级的学生数据
void writer_to_csv_writer(class_room_t *aclass, FILE *csv_file);
// 将此学生添加到 aclass 这个班级中。成功返回1， 失败返回 0。
int add_student_by_info(class_room_t *aclass, const char * student_name, 
    int chinese_score,int math_score);
// 此函数用来管理学生数据
void student_manager(class_room_t *aclass);

#endif  // __CLASS_ROOM_H
