#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "tools.h"
#include "student.h"
#include "class_room.h"

// 添加学生信息
void add_student(class_room_t *aclass)
{
    char student_name[MAX_STU_NAME_LEN*2];
    int chinese_score;
    int math_score;

    if (aclass->student_count >= MAX_STU_COUNT_IN_CLASS_ROOM) {
        printf("班级 %s 学生已满，如法添加学生信息\n", aclass->class_title);
        return;
    }

    printf("请输入学生姓名: ");
    fflush(stdout);
    scanf("%s", student_name);
    // fgets(student_name, sizeof(student_name), stdin);
    if (strlen(student_name) >= MAX_STU_NAME_LEN) {
        printf("学生的名字太长，添加失败!\n");
        return;
    }
    printf("请输入学生的语文成绩: ");
    fflush(stdout);
    scanf("%d", &chinese_score);
    if (chinese_score < 0 || chinese_score > 100) {
        printf("学生成绩不在合法范围内，添加失败!\n");
        return;
    }
    printf("请输入学生的数学成绩: ");
    fflush(stdout);
    scanf("%d", &math_score);
    if (math_score < 0 || math_score > 100) {
        printf("学生成绩不在合法范围内，添加失败!\n");
        return;
    }

    student_t astu;
    strcpy(astu.name, student_name);
    astu.chinese_score = chinese_score;
    astu.math_score = math_score;

    aclass->student[aclass->student_count] = astu;
    aclass->student_count++;
    printf("添加学生 %s 成功!", student_name);
}

// 修改语文成绩功能
void modify_chinese_score(class_room_t *aclass)
{
    int number = 0;
    int index;
    int new_score = 0;
    list_all_student_info(aclass);
    printf("请输入要修改语文成绩的学生的序号：");
    fflush(stdout);

    scanf("%d", &number);
    index = number - 1;
    if (index < 0 || index >= MAX_STU_COUNT_IN_CLASS_ROOM) {
        printf("您输入的序号有误，修改失败!\n");
        return;
    }
    student_t *astu = &aclass->student[index];
    printf("请输入%s的新的语文成绩: ", astu->name);
    fflush(stdout);
    scanf("%d", &new_score);
    astu->chinese_score = new_score;
    printf("修改%s的语文成绩成功！\n", astu->name);
}

// 修改数学成绩功能
void modify_math_score(class_room_t *aclass)
{
    int number = 0;
    int index;
    int new_score = 0;
    list_all_student_info(aclass);
    printf("请输入要修改数学成绩的学生的序号：");
    fflush(stdout);

    scanf("%d", &number);
    index = number - 1;
    if (index < 0 || index >= MAX_STU_COUNT_IN_CLASS_ROOM) {
        printf("您输入的序号有误，修改失败!\n");
        return;
    }
    student_t *astu = &aclass->student[index];
    printf("请输入%s的新的数学成绩: ", astu->name);
    fflush(stdout);
    scanf("%d", &new_score);
    astu->math_score = new_score;
    printf("修改%s的数学成绩成功！\n", astu->name);
}

// 删除学生信息
void del_student(class_room_t *aclass)
{
    int number = 0;
    int index;

    list_all_student_info(aclass);

    printf("请输入要修改数学成绩的学生的序号：");
    fflush(stdout);

    scanf("%d", &number);
    index = number - 1;
    if (index < 0 || index >= aclass->student_count) {
        printf("您输入的序号有错，删除失败!\n");
        return;
    }
    // 循环将 index +1 位置的数据覆盖 index 位置的数据
    for(; index < aclass->student_count-1; index++) {
        aclass->student[index] = aclass->student[index+1];
    }
    // 学生数减1
    aclass->student_count--;
}

// 显示所有学生的信息
void list_all_student_info(class_room_t *aclass)
{
    int i;
    const student_t *astu;
    char stu_name_buf[MAX_STU_NAME_LEN*2];

    printf("+------+----------------------+--------+--------+\n");
    printf("| 序号 |         姓名         |语文成绩|数学成绩|\n");
    printf("+------+----------------------+--------+--------+\n");
    for (i = 0; i < aclass->student_count; i++) {
        astu = &aclass->student[i];
        center_to_display_width(astu->name, 20, stu_name_buf);
        printf("| %4d | %s |  %4d  |  %4d  |\n", 
            i+1, stu_name_buf, astu->chinese_score, astu->math_score);
    }
    if (aclass->student_count)
        printf("+------+----------------------+--------+--------+\n");
}

// 写入一个班级的学生数据
void writer_to_csv_writer(class_room_t *aclass, FILE *csv_file)
{
    int i;
    for (i = 0; i < aclass->student_count; i++) {
        student_t *astu = &aclass->student[i];
        fprintf(csv_file, "%s,%s,%d,%d\r\n", aclass->class_title, 
            astu->name, astu->chinese_score, astu->math_score);
    }
}

// 将此学生添加到 aclass 这个班级中。成功返回1， 失败返回 0。
int add_student_by_info(class_room_t *aclass, const char * student_name, 
    int chinese_score,int math_score)
{
    if(aclass->student_count >= MAX_STU_COUNT_IN_CLASS_ROOM)
        return 0;  // 满了
    strcpy(aclass->student[aclass->student_count].name, student_name);
    aclass->student[aclass->student_count].chinese_score = chinese_score;
    aclass->student[aclass->student_count].math_score = math_score;
    aclass->student_count++;
    return 1;
}

// 此函数用来显示操作菜单
static void show_class_menu(class_room_t *aclass)
{
    printf("        %s-班级管理\n", aclass->class_title);
    printf("+-----------------------------------+\n");
    printf("| 1) 添加学生                       |\n");
    printf("| 2) 修改学生的语文成绩             |\n");
    printf("| 3) 修改学生的数学成绩             |\n");
    printf("| 4) 删除学生                       |\n");
    printf("| 5) 列出所有学生的成绩             |\n");
    printf("| 0) 退出班级                       |\n");
    printf("+-----------------------------------+\n");
    printf("请选择：");
    fflush(stdout);  
}

// 此函数用来管理学生数据
void student_manager(class_room_t *aclass)
{
    while(1) {
        int sel = 0;
        show_class_menu(aclass);
        scanf("%d", &sel);
        switch (sel)
        {
            case 1:  // 1) 添加学生
                add_student(aclass);
                break;
            case 2:  // 2) 修改学生的语文成绩
                modify_chinese_score(aclass);
                break;
            case 3:  // 3) 修改学生的数学成绩
                modify_math_score(aclass);
                break;
            case 4:  // 4) 删除学生
                del_student(aclass);
                break;
            case 5:  // 5) 列出所有学生的成绩
                list_all_student_info(aclass);
                break;
            case 0:  // 0) 退出班级
                return;
            default:
                printf("不存在的选项，请重新输入\n");
                sleep(2);  // 让程序睡眠2秒
        }
    }
}
